/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.managed.ManagedObjectGroup;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Collection;

public class AutoInventoryManagedObjectGroup
extends ManagedObjectGroup {
    private static final String TRACEMASK_T = "XFRMAIGT";
    private static final String TRACEMASK_F = "XFRMAIGF";
    private static final String TRACEMASK_D = "XFRMAIGD";
    ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();

    public AutoInventoryManagedObjectGroup(String name, UIInfo uiInfo) {
        super(name, uiInfo);
    }

    public void addChild(ObjectId child) {
        Trace.trace(TRACEMASK_T, "-> addChild(" + child + ")");
        if (this.getChildren().size() == 0) {
            this.mom.add(this);
        }
        super.addChild(child);
        Trace.trace(TRACEMASK_T, "<- addChild()");
    }

    public void addChildren(Collection children) {
        Trace.trace(TRACEMASK_T, "-> addChildren(" + children + ")");
        if (this.getChildren().size() == 0) {
            this.mom.add(this);
        }
        super.addChildren(children);
        Trace.trace(TRACEMASK_T, "<- addChildren()");
    }

    public boolean removeChild(ObjectId child) {
        Trace.trace(TRACEMASK_T, "-> removeChild(" + child + ")");
        boolean success = super.removeChild(child);
        if (success && this.getChildren().size() == 0) {
            this.removeFromMom();
        }
        Trace.trace(TRACEMASK_T, "<- removeChild() (return: " + success + ")");
        return success;
    }

    public boolean removeChildren(Collection children) {
        Trace.trace(TRACEMASK_T, "-> removeChildren(" + children + ")");
        boolean success = super.removeChildren(children);
        if (success && this.getChildren().size() == 0) {
            this.removeFromMom();
        }
        Trace.trace(TRACEMASK_T, "<- removeChildren() (return: " + success + ")");
        return success;
    }

    public void removeAllChildren() {
        Trace.trace(TRACEMASK_T, "-> removeAllChildren()");
        boolean success = super.removeChildren(this.getChildren());
        if (success) {
            this.removeFromMom();
        }
        Trace.trace(TRACEMASK_T, "<- removeAllChildren()");
    }

    private void removeFromMom() {
        this.removeAllPropertyChangeListeners();
        this.mom.remove(this.getObjectId());
    }
}

